/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.builders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.fabric.FluidHelper;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class FluidBuilder<T extends SimpleFlowableFluid, P>
extends AbstractBuilder<class_3611, T, P, FluidBuilder<T, P>> {
    private final String sourceName;
    private final String bucketName;
    private final class_2960 stillTexture;
    private final class_2960 flowingTexture;
    private final NonNullFunction<SimpleFlowableFluid.Properties, T> fluidFactory;
    @Nullable
    private NonNullSupplier<FluidVariantAttributeHandler> attributeHandler = null;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<SimpleFlowableFluid.Properties> fluidProperties;
    @Nullable
    private Supplier<Supplier<class_1921>> layer = null;
    @Nullable
    private NonNullSupplier<? extends SimpleFlowableFluid> source;
    private final List<class_6862<class_3611>> tags = new ArrayList<class_6862<class_3611>>();

    public static <P> FluidBuilder<SimpleFlowableFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, SimpleFlowableFluid.Flowing::new);
    }

    public static <T extends SimpleFlowableFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> fluidFactory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, fluidFactory).defaultLang().defaultSource().defaultBlock().defaultBucket();
        return ret;
    }

    public FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> fluidFactory) {
        super(owner, parent, "flowing_" + name, callback, class_7924.field_41270);
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.fluidFactory = fluidFactory;
        String bucketName = this.bucketName;
        this.fluidProperties = p -> p.bucket(() -> (class_1792)owner.get(bucketName, class_7924.field_41197).get()).block(() -> (class_2404)owner.get(name, class_7924.field_41254).get());
    }

    public FluidBuilder<T, P> fluidAttributes(NonNullSupplier<FluidVariantAttributeHandler> handler) {
        if (this.attributeHandler == null) {
            this.attributeHandler = handler;
        }
        return this;
    }

    public FluidBuilder<T, P> fluidProperties(NonNullConsumer<SimpleFlowableFluid.Properties> cons) {
        this.fluidProperties = this.fluidProperties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> defaultLang() {
        return this.lang(RegistrateLangProvider.toEnglishName(this.sourceName));
    }

    public FluidBuilder<T, P> lang(String name) {
        return (FluidBuilder)this.lang(flowing -> FluidHelper.getDescriptionId(flowing.method_15751()), name);
    }

    public FluidBuilder<T, P> renderType(Supplier<Supplier<class_1921>> layer) {
        if (this.layer == null) {
            this.onRegister(this::registerRenderType);
        }
        this.layer = layer;
        return this;
    }

    protected void registerRenderType(T entry) {
        EnvExecutor.runWhenOn(EnvType.CLIENT, () -> () -> BlockRenderLayerMap.INSTANCE.putFluids(this.layer.get().get(), new class_3611[]{entry, this.getSource()}));
    }

    public FluidBuilder<T, P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public FluidBuilder<T, P> source(NonNullFunction<SimpleFlowableFluid.Properties, ? extends SimpleFlowableFluid> factory) {
        this.defaultSource = false;
        this.source = NonNullSupplier.lazy(() -> (SimpleFlowableFluid)((Object)((Object)factory.apply(this.makeProperties()))));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public BlockBuilder<class_2404, FluidBuilder<T, P>> block() {
        return this.block1(class_2404::new);
    }

    public <B extends class_2404> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, class_4970.class_2251, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        return this.getOwner().block(this, this.sourceName, p -> (class_2404)factory.apply(supplier, (class_4970.class_2251)p)).properties(p -> class_4970.class_2251.method_9630((class_4970)class_2246.field_10382).method_42327()).blockstate((ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    public <B extends class_2404> BlockBuilder<B, FluidBuilder<T, P>> block1(NonNullBiFunction<? extends T, class_4970.class_2251, ? extends B> factory) {
        return this.block((supplier, settings) -> (class_2404)factory.apply((Object)((SimpleFlowableFluid)((Object)((Object)supplier.get()))), (class_4970.class_2251)settings));
    }

    @Beta
    public FluidBuilder<T, P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public FluidBuilder<T, P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<class_1755, FluidBuilder<T, P>> bucket() {
        return this.bucket(class_1755::new);
    }

    public <I extends class_1755> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<? extends SimpleFlowableFluid, class_1792.class_1793, ? extends I> factory) {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        NonNullSupplier<? extends SimpleFlowableFluid> source = this.source;
        if (source == null) {
            throw new IllegalStateException("Cannot create a bucket before creating a source block");
        }
        return this.getOwner().item(this, this.bucketName, p -> (class_1755)factory.apply((SimpleFlowableFluid)((Object)((Object)this.source.get())), (class_1792.class_1793)p)).properties(p -> p.method_7896(class_1802.field_8550).method_7889(1)).model((ctx, prov) -> prov.generated(ctx::getEntry, new class_2960(this.getOwner().getModid(), "item/" + this.bucketName)));
    }

    @Beta
    public FluidBuilder<T, P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> tag(class_6862<class_3611> ... tags) {
        FluidBuilder ret = (FluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryKey(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(prov::addTag).forEach(p -> p.add(this.getSource().method_40178().method_40237())));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> removeTag(class_6862<class_3611> ... tags) {
        this.tags.removeAll(Arrays.asList(tags));
        return (FluidBuilder)this.removeTag(ProviderType.FLUID_TAGS, tags);
    }

    private SimpleFlowableFluid getSource() {
        NonNullSupplier<? extends SimpleFlowableFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return (SimpleFlowableFluid)((Object)source.get());
    }

    private SimpleFlowableFluid.Properties makeProperties() {
        NonNullSupplier<? extends SimpleFlowableFluid> source = this.source;
        SimpleFlowableFluid.Properties ret = new SimpleFlowableFluid.Properties(source == null ? null : source::get, this.asSupplier());
        this.fluidProperties.accept(ret);
        return ret;
    }

    @Override
    protected T createEntry() {
        return (T)((Object)((SimpleFlowableFluid)((Object)this.fluidFactory.apply(this.makeProperties()))));
    }

    @Environment(value=EnvType.CLIENT)
    protected void registerDefaultRenderer(T flowing) {
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)this.getSource(), flowing, (FluidRenderHandler)new SimpleFluidRenderHandler(this.stillTexture, this.flowingTexture));
    }

    @Override
    public FluidEntry<T> register() {
        NonNullSupplier<? extends SimpleFlowableFluid> source;
        if (this.attributeHandler != null) {
            this.onRegister(entry -> {
                FluidVariantAttributeHandler handler = (FluidVariantAttributeHandler)this.attributeHandler.get();
                FluidVariantAttributes.register((class_3611)entry, (FluidVariantAttributeHandler)handler);
                FluidVariantAttributes.register((class_3611)this.getSource(), (FluidVariantAttributeHandler)handler);
            });
        }
        EnvExecutor.runWhenOn(EnvType.CLIENT, () -> () -> this.onRegister(this::registerDefaultRenderer));
        if (this.defaultSource == Boolean.TRUE) {
            this.source(SimpleFlowableFluid.Source::new);
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, class_7924.field_41270, this, source::get);
        return (FluidEntry)super.register();
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new FluidEntry<T>(this.getOwner(), delegate);
    }
}

